/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class StringValueContainerEntry
implements ValueContainerEntry<String> {
    private final ITextComponent displayName;
    private final String name;
    private final String previousValue;
    private String value;
    private Predicate<String> validator;

    public StringValueContainerEntry(ITextComponent displayName, String name, String value) {
        this.displayName = displayName;
        this.name = name;
        this.previousValue = value;
        this.value = value;
        this.validator = null;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return ValueContainerEntry.InputType.TEXT_FIELD;
    }

    @Override
    public <E> E getValue() {
        return (E)this.value;
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.previousValue;
    }

    @Override
    public boolean isDirty() {
        return !this.value.equals(this.previousValue);
    }

    @Override
    public String getDisplay() {
        return this.value;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74778_a(this.getName(), this.value);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 8) ? nbt.func_74779_i(this.getName()) : this.previousValue;
    }

    @Override
    public void parse(String data) {
        this.value = data;
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public StringValueContainerEntry setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }
}

