/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client;

import com.legacy.mining_helmet.MiningHelmetConfig;
import com.legacy.mining_helmet.MiningHelmetMod;
import com.legacy.mining_helmet.MiningHelmetRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DynamicLightingManager {
    private static final Minecraft MC = Minecraft.func_71410_x();
    public static final Map<BlockPos, LightData> SOURCES = new ConcurrentHashMap<BlockPos, LightData>();

    public static void tick() {
        if (DynamicLightingManager.MC.field_71439_g != null && DynamicLightingManager.MC.field_71441_e != null && DynamicLightingManager.MC.field_71439_g.field_70173_aa % MiningHelmetConfig.lightRefreshRate() == 0) {
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
            });
            DynamicLightingManager.MC.field_71441_e.func_175647_a(LivingEntity.class, DynamicLightingManager.MC.field_71439_g.func_174813_aQ().func_186662_g((double)MiningHelmetConfig.maxVisibleDistance()), DynamicLightingManager::shouldGlow).forEach(e -> SOURCES.put(e.func_233580_cy_().func_177981_b((int)e.func_70047_e()), new LightData()));
            SOURCES.forEach((blockPos, data) -> DynamicLightingManager.MC.field_71441_e.func_72863_F().func_212863_j_().func_215568_a(blockPos));
            SOURCES.entrySet().removeIf(entry -> !((LightData)entry.getValue()).shouldStay);
        }
    }

    public static boolean shouldGlow(LivingEntity entity) {
        if (entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == MiningHelmetRegistry.MINING_HELMET) {
            boolean visible = MiningHelmetConfig.seeThroughWalls();
            if (!visible) {
                Vector3d entityPos;
                Vector3d playerPos = new Vector3d(DynamicLightingManager.MC.field_71439_g.func_226277_ct_(), DynamicLightingManager.MC.field_71439_g.func_226280_cw_(), DynamicLightingManager.MC.field_71439_g.func_226281_cx_());
                boolean bl = visible = DynamicLightingManager.MC.field_71439_g.field_70170_p.func_217299_a(new RayTraceContext(playerPos, entityPos = new Vector3d(entity.func_226277_ct_(), entity.func_226280_cw_(), entity.func_226281_cx_()), RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c() == RayTraceResult.Type.MISS;
                if (!visible && DynamicLightingManager.MC.field_71439_g.func_70032_d((Entity)entity) < 24.0f) {
                    visible = true;
                }
            }
            return visible;
        }
        return false;
    }

    public static void cleanUp() {
        if (SOURCES.size() > 0 && DynamicLightingManager.MC.field_71441_e != null) {
            MiningHelmetMod.LOGGER.info(String.format("Cleaning up light data for %s light sources", SOURCES.size()));
            SOURCES.forEach((blockPos, data) -> {
                data.shouldStay = false;
                DynamicLightingManager.MC.field_71441_e.func_72863_F().func_212863_j_().func_215568_a(blockPos);
            });
            SOURCES.clear();
        }
    }

    public static class LightData {
        public boolean shouldStay = true;
    }
}

