/*
 * Decompiled with CFR 0.152.
 */
package me.jonathing.minecraft.verificationutil;

public class FingerprintInfo {
    private final boolean fingerprintVerified;
    private final String fingerprint;
    private final String expectedFingerprint;
    private final String trustData;

    protected FingerprintInfo(String fingerprint, String expectedFingerprint, String trustData) {
        this.fingerprint = fingerprint;
        this.trustData = trustData;
        if (expectedFingerprint.isEmpty()) {
            throw new NullPointerException("Expected fingerprint cannot be empty!");
        }
        this.expectedFingerprint = expectedFingerprint;
        this.fingerprintVerified = fingerprint.equals(expectedFingerprint.toLowerCase()) && !fingerprint.isEmpty();
    }

    protected boolean hasFingerprint() {
        return !this.fingerprint.isEmpty();
    }

    protected boolean matchesExpectedFingerprint() {
        return this.fingerprintVerified;
    }

    protected String getFingerprint() {
        return !this.fingerprint.isEmpty() ? this.fingerprint : "UNSIGNED";
    }

    protected String getExpectedFingerprint() {
        return this.expectedFingerprint;
    }

    protected String getTrustData() {
        return !this.trustData.isEmpty() ? this.trustData : "NONE";
    }
}

