/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin;

import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity> {
    @Inject(method={"getBlockLightLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBlockLight(T entity, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (!DynamicLightsReforged.isEnabled()) {
            return;
        }
        int vanilla = cir.getReturnValueI();
        int entityLuminance = ((DynamicLightSource)entity).getLuminance();
        if (entityLuminance >= 15) {
            cir.setReturnValue((Object)entityLuminance);
        }
        int posLuminance = (int)DynamicLightsReforged.getDynamicLightLevel(pos);
        cir.setReturnValue((Object)Math.max(Math.max(vanilla, entityLuminance), posLuminance));
    }
}

