/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.cache;

import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedObject<T> {
    protected long lastUsed = System.currentTimeMillis();
    @NotNull
    protected T object;
    @NotNull
    protected final Optional<Consumer<T>> onDestroy;

    public CachedObject(@NotNull T object) {
        this(object, null);
    }

    public CachedObject(@NotNull T object, @Nullable Consumer<T> onDestroy) {
        this.object = object;
        this.onDestroy = Optional.ofNullable(onDestroy);
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    @NotNull
    public T getObject() {
        return this.object;
    }

    @NotNull
    public T update() {
        this.lastUsed = System.currentTimeMillis();
        return this.getObject();
    }

    public void destroy() {
        this.onDestroy.ifPresent(func -> func.accept(this.object));
    }
}

