/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.utils;

import java.util.Optional;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtils {
    private LambdaUtils() throws IllegalAccessException {
        throw new IllegalAccessException("Cannot instantiate LambdaUtils: it contains only static methods.");
    }

    public static Optional<String> makeOptionalFromString(@Nullable String value) {
        return Optional.ofNullable(value).filter(str -> !str.isEmpty());
    }

    public static Optional<Integer> parseOptionalIntFromString(@NotNull String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static int parseIntFromString(@NotNull String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static TimerTask newTimerTaskFromLambda(final Runnable runnable) {
        return new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        };
    }
}

