/*
 * Decompiled with CFR 0.152.
 */
package org.aperlambda.lambdacommon.utils.function;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface PairPredicate<X, Y> {
    public boolean test(X var1, Y var2);

    default public PairPredicate<X, Y> negate() {
        return (x, y) -> !this.test(x, y);
    }

    default public PairPredicate<X, Y> and(@NotNull PairPredicate<? super X, ? super Y> other) {
        Objects.requireNonNull(other);
        return (x, y) -> this.test(x, y) && other.test(x, y);
    }

    default public PairPredicate<X, Y> or(@NotNull PairPredicate<? super X, ? super Y> other) {
        Objects.requireNonNull(other);
        return (x, y) -> this.test(x, y) || other.test(x, y);
    }

    public static <X, Y> PairPredicate<X, Y> not(@NotNull PairPredicate<X, Y> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }
}

