/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.common.systems;

import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.common.configuration.ConfigData;
import mirsario.cameraoverhaul.core.callbacks.CameraUpdateCallback;
import mirsario.cameraoverhaul.core.callbacks.ModifyCameraTransformCallback;
import mirsario.cameraoverhaul.core.structures.Transform;
import mirsario.cameraoverhaul.core.utils.MathUtils;
import mirsario.cameraoverhaul.core.utils.Vec2fUtils;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;

public final class CameraSystem
implements CameraUpdateCallback,
ModifyCameraTransformCallback {
    private static double prevForwardVelocityPitchOffset;
    private static double prevVerticalVelocityPitchOffset;
    private static double prevStrafingRollOffset;
    private static double prevCameraYaw;
    private static double yawDeltaRollOffset;
    private static double yawDeltaRollTargetOffset;
    private static final double lerpSpeed = 1.0;
    private static final Transform offsetTransform;

    public CameraSystem() {
        CameraUpdateCallback.EVENT.Register(this);
        ModifyCameraTransformCallback.EVENT.Register(this);
        CameraOverhaul.Logger.info("CameraOverhaul - CameraSystem is ready.");
    }

    @Override
    public void OnCameraUpdate(ActiveRenderInfo camera, Transform cameraTransform, float deltaTime) {
        CameraSystem.offsetTransform.position = new Vector3d(0.0, 0.0, 0.0);
        CameraSystem.offsetTransform.eulerRot = new Vector3d(0.0, 0.0, 0.0);
        ConfigData config = CameraOverhaul.instance.config;
        if (!config.enabled) {
            return;
        }
        Vector3d velocity = camera.func_216773_g().func_213322_ci();
        Vector2f relativeXZVelocity = Vec2fUtils.Rotate(new Vector2f((float)velocity.field_72450_a, (float)velocity.field_72449_c), 360.0f - (float)cameraTransform.eulerRot.field_72448_b);
        this.VerticalVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor);
        this.ForwardVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor);
        this.YawDeltaRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor);
        this.StrafingRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.strafingRollFactor);
        prevCameraYaw = cameraTransform.eulerRot.field_72448_b;
    }

    @Override
    public Transform ModifyCameraTransform(ActiveRenderInfo camera, Transform transform) {
        return new Transform(transform.position.func_178787_e(CameraSystem.offsetTransform.position), transform.eulerRot.func_178787_e(CameraSystem.offsetTransform.eulerRot));
    }

    private void VerticalVelocityPitchOffset(Transform inputTransform, Transform outputTransform, Vector3d velocity, Vector2f relativeXZVelocity, double deltaTime, float intensity) {
        double verticalVelocityPitchOffset = velocity.field_72448_b * 2.75;
        if (velocity.field_72448_b < 0.0) {
            verticalVelocityPitchOffset *= 2.25;
        }
        prevVerticalVelocityPitchOffset = verticalVelocityPitchOffset = MathUtils.Lerp(prevVerticalVelocityPitchOffset, verticalVelocityPitchOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.func_72441_c(verticalVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void ForwardVelocityPitchOffset(Transform inputTransform, Transform outputTransform, Vector3d velocity, Vector2f relativeXZVelocity, double deltaTime, float intensity) {
        double forwardVelocityPitchOffset = (double)relativeXZVelocity.field_189983_j * 5.0;
        prevForwardVelocityPitchOffset = forwardVelocityPitchOffset = MathUtils.Lerp(prevForwardVelocityPitchOffset, forwardVelocityPitchOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.func_72441_c(forwardVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void YawDeltaRollOffset(Transform inputTransform, Transform outputTransform, Vector3d velocity, Vector2f relativeXZVelocity, double deltaTime, float intensity) {
        double yawDelta = prevCameraYaw - inputTransform.eulerRot.field_72448_b;
        if (yawDelta > 180.0) {
            yawDelta = 360.0 - yawDelta;
        } else if (yawDelta < -180.0) {
            yawDelta = -360.0 - yawDelta;
        }
        yawDeltaRollOffset = MathUtils.Lerp(yawDeltaRollOffset, yawDeltaRollTargetOffset += yawDelta * 0.07, deltaTime * 1.0 * 10.0);
        outputTransform.eulerRot = outputTransform.eulerRot.func_72441_c(0.0, 0.0, yawDeltaRollOffset * (double)intensity);
        yawDeltaRollTargetOffset = MathUtils.Lerp(yawDeltaRollTargetOffset, 0.0, deltaTime * 0.35);
    }

    private void StrafingRollOffset(Transform inputTransform, Transform outputTransform, Vector3d velocity, Vector2f relativeXZVelocity, double deltaTime, float intensity) {
        double strafingRollOffset = (double)(-relativeXZVelocity.field_189982_i) * 15.0;
        prevStrafingRollOffset = strafingRollOffset = MathUtils.Lerp(prevStrafingRollOffset, strafingRollOffset, deltaTime * 1.0);
        outputTransform.eulerRot = outputTransform.eulerRot.func_72441_c(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    static {
        offsetTransform = new Transform();
    }
}

