/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkpaintings;

import net.darkhax.darkpaintings.authors.AuthorManager;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="darkpaintings")
public class DarkPaintings {
    public static final String MOD_ID = "darkpaintings";
    public static final Logger LOG = LogManager.getLogger((String)"Dark Paintings");

    public DarkPaintings() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addGenericListener(PaintingType.class, this::registerPaintings);
    }

    private void registerPaintings(RegistryEvent.Register<PaintingType> event) {
        IForgeRegistry registry = event.getRegistry();
        TextComponent authorDarkhax = AuthorManager.makeAuthor("darkhax");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "in_the_air", 32, 16, authorDarkhax);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "skyblock", 16, 16, authorDarkhax);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "mr_moon", 16, 16, authorDarkhax);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "tetromino", 16, 32, authorDarkhax);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "daybreak", 32, 16, authorDarkhax);
        TextComponent authormmg28rtt = AuthorManager.makeAuthor("mmg28rtt");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "planets", 32, 16, authormmg28rtt);
        TextComponent authorFuryDev = AuthorManager.makeAuthor("furydev");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "village", 64, 32, authorFuryDev);
        TextComponent authorAxeonlotl = AuthorManager.makeAuthor("axeonlotl");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "oceanic_view", 32, 16, authorAxeonlotl);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "watching_the_sunset", 32, 16, authorAxeonlotl);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "enderman", 32, 16, authorAxeonlotl);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "afternoon_volcano", 16, 32, authorAxeonlotl);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "crimson_taiga", 32, 16, authorAxeonlotl);
        TextComponent authorWouter = AuthorManager.makeAuthor("wouter");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "lumberjack", 64, 32, authorWouter);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "summer_heat", 32, 16, authorWouter);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "the_tower", 16, 32, authorWouter);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "bubbles", 16, 16, authorWouter);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "a_distant_light", 32, 16, authorWouter);
        TextComponent authorVydax = AuthorManager.makeAuthor("vydax");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "the_wheel", 32, 32, authorVydax);
        TextComponent authorAbsolem = AuthorManager.makeAuthor("absolem");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "whale_dream", 32, 32, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "cottage_by_the_river", 16, 16, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "seavibe", 16, 16, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "antler_maze", 16, 32, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "turkey", 16, 16, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "kerstball", 16, 16, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "snowman_scenery", 32, 16, authorAbsolem);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "santa_moon", 32, 32, authorAbsolem);
        TextComponent authorPunpudle = AuthorManager.makeAuthor("punpudle");
        this.createPainting((IForgeRegistry<PaintingType>)registry, "the_secret_neighborhood", 32, 32, authorPunpudle);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "last_dreams_at_candyland", 32, 16, authorPunpudle);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "the_most_sweet_candy", 16, 16, authorPunpudle);
        this.createPainting((IForgeRegistry<PaintingType>)registry, "sir_ramfrez_yarn_paradise", 16, 16, authorPunpudle);
    }

    private PaintingType createPainting(IForgeRegistry<PaintingType> registry, String id, int width, int height, TextComponent author) {
        PaintingType type = new PaintingType(width, height);
        type.setRegistryName(MOD_ID, id);
        registry.register((IForgeRegistryEntry)type);
        AuthorManager.registerAuthor(type, author);
        return type;
    }
}

