/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkpaintings.addons.hwyla;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import net.darkhax.darkpaintings.addons.hwyla.DarkPaintingsHwylaPlugin;
import net.darkhax.darkpaintings.authors.AuthorManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DarkPaintingsComponentProvider
implements IEntityComponentProvider {
    private static final Map<PaintingType, ITextComponent> titles = new HashMap<PaintingType, ITextComponent>();

    @Nullable
    public static ITextComponent getTitle(PaintingType painting) {
        return titles.computeIfAbsent(painting, p -> {
            ResourceLocation id = p.getRegistryName();
            String titleKey = "painting." + id.func_110624_b() + "." + id.func_110623_a() + ".title";
            return I18n.func_188566_a((String)titleKey) ? new TranslationTextComponent(titleKey).func_240699_a_(TextFormatting.WHITE) : null;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof PaintingEntity) {
            PaintingEntity painting = (PaintingEntity)accessor.getEntity();
            ITextComponent title = DarkPaintingsComponentProvider.getTitle(painting.field_70522_e);
            if (title != null && config.get(DarkPaintingsHwylaPlugin.SHOW_TITLE)) {
                tooltip.set(0, (ITextComponent)new TranslationTextComponent("tooltip.darkpaintings.title", new Object[]{accessor.getEntity().func_145748_c_(), title}));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getEntity() instanceof PaintingEntity) {
            PaintingEntity painting = (PaintingEntity)accessor.getEntity();
            TextComponent artist = AuthorManager.getAuthor(painting.field_70522_e);
            if (artist != null && config.get(DarkPaintingsHwylaPlugin.SHOW_ARTIST)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.darkpaintings.artist", new Object[]{artist}));
            }
            if (config.get(DarkPaintingsHwylaPlugin.SHOW_ID)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.darkpaintings.id", new Object[]{painting.field_70522_e.getRegistryName()}));
            }
        }
    }
}

