/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkpaintings.authors;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AuthorManager {
    private static final Map<PaintingType, TextComponent> authorNames = new HashMap<PaintingType, TextComponent>();

    public static void registerAuthor(PaintingType painting, TextComponent author) {
        authorNames.put(painting, author);
    }

    public static TextComponent getAuthor(PaintingType painting) {
        return authorNames.computeIfAbsent(painting, p -> {
            ResourceLocation id = p.getRegistryName();
            String artistKey = "painting." + id.func_110624_b() + "." + id.func_110623_a() + ".artist";
            return I18n.func_188566_a((String)artistKey) ? new TranslationTextComponent("tooltip.darkpaintings.artist", new Object[]{new TranslationTextComponent(artistKey)}) : null;
        });
    }

    public static TextComponent makeAuthor(String author) {
        return new TranslationTextComponent("darkpaintings.author." + author);
    }

    static {
        TextComponent authorKristoffer = AuthorManager.makeAuthor("kristoffer");
        AuthorManager.registerAuthor(PaintingType.field_200843_b, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200844_c, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200845_d, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200846_e, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200847_f, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200848_g, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200849_h, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200850_i, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200851_j, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200852_k, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200853_l, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200854_m, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200855_n, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200856_o, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200857_p, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200858_q, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200859_r, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200860_s, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200861_t, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200863_v, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200864_w, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200865_x, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200866_y, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200867_z, authorKristoffer);
        AuthorManager.registerAuthor(PaintingType.field_200837_A, authorKristoffer);
        TextComponent authorUnknown = AuthorManager.makeAuthor("unknown");
        AuthorManager.registerAuthor(PaintingType.field_200862_u, authorUnknown);
    }
}

