/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.building.block.MagmaBrickBlock;
import vazkii.quark.content.building.module.SoulSandstoneModule;

@LoadModule(category=ModuleCategory.BUILDING)
public class MoreBrickTypesModule
extends QuarkModule {
    @Config(flag="sandy_bricks")
    public boolean enableSandyBricks = true;
    @Config(flag="snow_bricks")
    public boolean enableSnowBricks = true;
    @Config(flag="magma_bricks")
    public boolean enableMagmaBricks = true;
    @Config(flag="charred_nether_bricks")
    public boolean enableCharredNetherBricks = true;
    @Config(flag="blackstone_variant_bricks")
    public boolean enableBlackstoneVariantBricks = true;
    @Config(flag="blue_nether_bricks", description="This also comes with a utility recipe for Red Nether Bricks")
    public boolean enableBlueNetherBricks = true;
    @Config(flag="sandstone_bricks", description="This also includes Red Sandstone Bricks and Soul Sandstone Bricks")
    public boolean enableSandstoneBricks = true;

    @Override
    public void construct() {
        this.add("sandy", Blocks.field_150322_A, () -> this.enableSandyBricks);
        this.add("snow", Blocks.field_196604_cC, () -> this.enableSnowBricks);
        this.add("charred_nether", Blocks.field_196653_dH, () -> this.enableCharredNetherBricks);
        this.add("blue_nether", Blocks.field_196653_dH, () -> this.enableBlueNetherBricks);
        this.add("sandstone", Blocks.field_150322_A, () -> this.enableSandstoneBricks);
        this.add("red_sandstone", Blocks.field_180395_cM, () -> this.enableSandstoneBricks);
        this.add("soul_sandstone", Blocks.field_150322_A, () -> this.enableSandstoneBricks && ModuleLoader.INSTANCE.isModuleEnabled(SoulSandstoneModule.class));
        this.add("twisted_blackstone", Blocks.field_235411_nu_, () -> this.enableBlackstoneVariantBricks);
        this.add("weeping_blackstone", Blocks.field_235411_nu_, () -> this.enableBlackstoneVariantBricks);
        VariantHandler.addSlabStairsWall(new MagmaBrickBlock(this).setCondition(() -> this.enableMagmaBricks));
    }

    private void add(String name, Block parent, BooleanSupplier cond) {
        VariantHandler.addSlabStairsWall(new QuarkBlock(name + "_bricks", this, ItemGroup.field_78030_b, AbstractBlock.Properties.func_200950_a((AbstractBlock)parent).func_200948_a(2.0f, 6.0f).func_235861_h_().harvestTool(parent.field_149764_J == Material.field_151596_z ? ToolType.SHOVEL : ToolType.PICKAXE)).setCondition(cond));
    }
}

