/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.block.CaveCrystalClusterBlock;
import vazkii.quark.content.world.module.SpiralSpiresModule;
import vazkii.quark.content.world.module.underground.CaveCrystalUndergroundBiomeModule;

public class CaveCrystalBlock
extends QuarkGlassBlock {
    public final float[] colorComponents;
    public final Vector3d colorVector;
    final boolean waxed;
    public CaveCrystalClusterBlock cluster;
    public CaveCrystalBlock alternate;

    public CaveCrystalBlock(String regname, int color, QuarkModule module, MaterialColor materialColor, boolean waxed) {
        super(regname, module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)materialColor).func_200948_a(0.3f, 0.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(b -> 11).harvestTool(ToolType.PICKAXE).func_235861_h_().harvestLevel(0).func_200944_c().func_226896_b_());
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        this.colorComponents = new float[]{r, g, b2};
        this.colorVector = new Vector3d((double)r, (double)g, (double)b2);
        this.waxed = waxed;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.TRANSLUCENT);
    }

    private boolean canGrow(World world, BlockPos pos) {
        if (!this.waxed && CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance >= 1 && pos.func_177956_o() < 24 && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            return i < 4;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.waxed) {
            if (stack.func_77973_b().getToolTypes(stack).contains(ToolType.AXE)) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, this.alternate.func_176223_P());
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                }
                if (!player.func_184812_l_()) {
                    MiscUtil.damageStack(player, hand, stack, 1);
                }
                return ActionResultType.SUCCESS;
            }
        } else if (stack.func_77973_b() == Items.field_226635_pU_) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, this.alternate.func_176223_P());
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_226138_eS_, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (!player.func_184812_l_()) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.canGrow((World)worldIn, pos) && random.nextInt(CaveCrystalUndergroundBiomeModule.caveCrystalGrowthChance) == 0) {
            BlockState down = worldIn.func_180495_p(pos.func_177977_b());
            BlockPos up = pos.func_177984_a();
            worldIn.func_175656_a(up, state);
            if (down.func_177230_c() == SpiralSpiresModule.myalite_crystal && ModuleLoader.INSTANCE.isModuleEnabled(SpiralSpiresModule.class) && SpiralSpiresModule.renewableMyalite) {
                worldIn.func_175656_a(pos, SpiralSpiresModule.myalite_crystal.func_176223_P());
            } else {
                for (Direction d : Direction.values()) {
                    BlockPos offPos = up.func_177972_a(d);
                    if (!worldIn.func_175623_d(offPos) || random.nextInt(3) != 0) continue;
                    worldIn.func_175656_a(offPos, (BlockState)this.cluster.func_176223_P().func_206870_a(CaveCrystalClusterBlock.FACING, (Comparable)d));
                }
            }
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.canGrow(worldIn, pos)) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197608_a, x, y, z, (double)this.colorComponents[0], (double)this.colorComponents[1], (double)this.colorComponents[2]);
        }
        if (!this.waxed) {
            for (int i = 0; i < 4; ++i) {
                double range = 5.0;
                double ox = rand.nextDouble() * range - range / 2.0;
                double oy = rand.nextDouble() * range - range / 2.0;
                double oz = rand.nextDouble() * range - range / 2.0;
                double x = (double)pos.func_177958_n() + 0.5 + ox;
                double y = (double)pos.func_177956_o() + 0.5 + oy;
                double z = (double)pos.func_177952_p() + 0.5 + oz;
                float size = 0.4f + rand.nextFloat() * 0.5f;
                if (rand.nextDouble() < 0.1) {
                    double ol = (ox * ox + oy * oy + oz * oz) * -2.0;
                    if (ol == 0.0) {
                        ol = 1.0E-4;
                    }
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, ox / ol, oy / ol, oz / ol);
                }
                worldIn.func_195594_a((IParticleData)new RedstoneParticleData(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], size), x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return this.colorComponents;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        return this.colorVector;
    }
}

