/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.ChorusVegetationModule;

public class ChorusVegetationBlock
extends QuarkBlock
implements IGrowable,
IForgeShearable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final boolean simple;

    public ChorusVegetationBlock(String regname, QuarkModule module, boolean simple) {
        super(regname, module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200946_b().func_200947_a(SoundType.field_185850_c).func_200944_c());
        this.simple = simple;
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (random.nextDouble() < ChorusVegetationModule.passiveTeleportChance) {
            this.teleport(pos, random, worldIn, state);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.2 + rand.nextDouble() * 0.6, (double)pos.func_177956_o() + 0.3, (double)pos.func_177952_p() + 0.2 + rand.nextDouble() * 0.6, 0.0, 0.0, 0.0);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        BlockPos target;
        if (this.simple && worldIn instanceof ServerWorld && entity instanceof LivingEntity && !(entity instanceof EndermanEntity) && !(entity instanceof EndermiteEntity) && (target = this.teleport(pos, worldIn.field_73012_v, (ServerWorld)worldIn, state)) != null && worldIn.field_73012_v.nextDouble() < ChorusVegetationModule.endermiteSpawnChance) {
            EndermiteEntity mite = new EndermiteEntity(EntityType.field_200804_r, worldIn);
            mite.func_70107_b((double)target.func_177958_n(), (double)target.func_177956_o(), (double)target.func_177952_p());
            worldIn.func_217376_c((Entity)mite);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof ServerWorld) {
            this.runAwayFromWater(pos, worldIn.field_73012_v, (ServerWorld)worldIn, state);
        }
    }

    private void runAwayFromWater(BlockPos pos, Random random, ServerWorld worldIn, BlockState state) {
        for (Direction d : Direction.values()) {
            BlockPos test = pos.func_177972_a(d);
            FluidState fluid = worldIn.func_204610_c(test);
            if (fluid.func_206886_c() != Fluids.field_204546_a && fluid.func_206886_c() != Fluids.field_207212_b) continue;
            this.teleport(pos, random, worldIn, state, 8, 1.0);
            return;
        }
    }

    private BlockPos teleport(BlockPos pos, Random random, ServerWorld worldIn, BlockState state) {
        return this.teleport(pos, random, worldIn, state, 4, 1.0 - ChorusVegetationModule.teleportDuplicationChance);
    }

    private BlockPos teleport(BlockPos pos, Random random, ServerWorld worldIn, BlockState state, int range, double growthChance) {
        BlockState stateAt;
        int xOff = 0;
        int zOff = 0;
        do {
            xOff = random.nextInt(range + 1) - range / 2;
            zOff = random.nextInt(range + 1) - range / 2;
        } while (xOff == 0 && zOff == 0);
        BlockPos newPos = pos.func_177982_a(xOff, 10, zOff);
        for (int i = 0; i < 20 && (stateAt = worldIn.func_180495_p(newPos)).func_177230_c() != Blocks.field_150377_bs; ++i) {
            newPos = newPos.func_177977_b();
        }
        if (worldIn.func_180495_p(newPos).func_177230_c() == Blocks.field_150377_bs && worldIn.func_180495_p(newPos.func_177984_a()).func_196958_f()) {
            newPos = newPos.func_177984_a();
            worldIn.func_175656_a(newPos, state);
            if (random.nextDouble() < growthChance) {
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                worldIn.func_195598_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.25, (double)pos.func_177952_p(), 50, 0.25, 0.25, 0.25, 1.0);
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 5.0f + random.nextFloat());
            }
            worldIn.func_195598_a((IParticleData)ParticleTypes.field_239819_as_, (double)newPos.func_177958_n() + 0.5, (double)newPos.func_177956_o() - 0.25, (double)newPos.func_177952_p(), 50, 0.25, 0.25, 0.25, 0.05);
            return newPos;
        }
        return null;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        for (int i = 0; i < 3 + rand.nextInt(3); ++i) {
            this.teleport(pos, rand, worldIn, state, 10, 0.0);
        }
        this.teleport(pos, rand, worldIn, state, 4, 1.0);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150377_bs;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_235688_at_ || super.func_196266_a(state, worldIn, pos, type);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }
}

